﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace OdtwarzaczMultimedialny
{
    public partial class Lista : Form
    {
        // Utworzenie nowej listy
        WMPLib.IWMPPlaylist lista =
            Form1.player.playlistCollection.newPlaylist("Moja lista");

        public Lista()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK && Form1.player != null)
            {
                foreach(string plik in openFileDialog1.FileNames)
                {             
                    // Dodanie pliku do biblioteki       
                    WMPLib.IWMPMedia3 media =
                        (WMPLib.IWMPMedia3)Form1.player.mediaCollection.
                        add(plik);

                    // Dodanie pliku do listy odtwarzania
                    lista.insertItem(listBox1.Items.Count, media);

                    // Pobranie informacji o autorze i nazwie utworu
                    string info = media.getItemInfo("Author") + " - " 
                        + media.getItemInfo("Title");
            
                    listBox1.Items.Add(info);
                }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1)
            {                
                WMPLib.IWMPMedia3 media = 
                    (WMPLib.IWMPMedia3)lista.get_Item(listBox1.SelectedIndex);                      
                // Usunięcie pliku z listy odtwarzania
                lista.removeItem(media);
                listBox1.Items.RemoveAt(listBox1.SelectedIndex);
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            // Czyszczenie zawartości listy
            listBox1.Items.Clear();            
            if (lista.count > 0)
                lista.clear();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1 && lista.count > 0)
            {
                Form1.player.currentMedia = lista.get_Item(listBox1.SelectedIndex);
                if (Form1.player.playState == WMPLib.WMPPlayState.wmppsPlaying)
                    Form1.player.Ctlcontrols.stop();                
                Form1.odtwarzaj();
            }            
        }

        private void button5_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex > 0 && lista.count > 0)
            {
                Form1.player.currentMedia = lista.get_Item(listBox1.SelectedIndex - 1);
                if (Form1.player.playState == WMPLib.WMPPlayState.wmppsPlaying)
                    Form1.player.Ctlcontrols.stop();
                Form1.odtwarzaj();
                listBox1.SelectedIndex -= 1;
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex < listBox1.Items.Count - 1 && lista.count > 0)
            {
                Form1.player.currentMedia = lista.get_Item(listBox1.SelectedIndex + 1);
                if (Form1.player.playState == WMPLib.WMPPlayState.wmppsPlaying)
                    Form1.player.Ctlcontrols.stop();
                Form1.odtwarzaj();
                listBox1.SelectedIndex += 1;
            }
        }

        private void button7_Click(object sender, EventArgs e)
        {
            this.Visible = false;
        }

        private void listBox1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            button4_Click(sender, e);
        }
    }
}
